"use strict";
//
// Copyright 2021 Signal Messenger, LLC.
// SPDX-License-Identifier: AGPL-3.0-only
//
Object.defineProperty(exports, "__esModule", { value: true });
const ByteArray_1 = require("../internal/ByteArray");
const Native = require("../../../Native");
const ReceiptSerial_1 = require("./ReceiptSerial");
class ReceiptCredentialPresentation extends ByteArray_1.default {
    constructor(contents) {
        super(contents, Native.ReceiptCredentialPresentation_CheckValidContents);
    }
    getReceiptExpirationTime() {
        return Native.ReceiptCredentialPresentation_GetReceiptExpirationTime(this.contents);
    }
    getReceiptLevel() {
        return Native.ReceiptCredentialPresentation_GetReceiptLevel(this.contents).readBigUInt64BE();
    }
    getReceiptSerialBytes() {
        return new ReceiptSerial_1.default(Native.ReceiptCredentialPresentation_GetReceiptSerial(this.contents));
    }
}
exports.default = ReceiptCredentialPresentation;
ReceiptCredentialPresentation.SIZE = 329;
//# sourceMappingURL=ReceiptCredentialPresentation.js.map